import lejos.nxt.*;
import lejos.nxt.addon.*;
import lejos.nxt.comm.*;
import java.io.*;
/**
 * This program controls the printer head, grabbing new bricks to print and
 * placing bricks on the base.
 *
 * @author Will Gorman (wgorman@hotmail.com)
 **/
public class MakerLegoBot {

	static final int PICKUP_MS = 1600; // milliseconds	

	public static void moveBackwards(Motor m, int max) throws Exception {
		int s = 50;
		int start = m.getTachoCount();
		m.backward();
		int dc = 0;
		for (int i = 0; i < max && (dc < 2); i++) {
			Thread.sleep(s);
			if (m.getTachoCount() - start >= 0) dc++;
			start = m.getTachoCount();
		}
	}

	public static void moveForwards(Motor m, int max)  throws Exception {
		int s = 50;
		int start = m.getTachoCount();
		m.forward();
		int dc = 0;
		for (int i = 0; i < max && (dc < 2); i++) {
			Thread.sleep(s);
			if (m.getTachoCount() - start <= 0) dc++;
			start = m.getTachoCount();
		}
	}

	public static void pickUpLego() throws Exception {
		drawString("pickUpLego");
		Motor.C.backward();
		Thread.sleep(PICKUP_MS);
		Motor.C.flt();
		Motor.C.forward();
		Thread.sleep(PICKUP_MS);
		Motor.C.stop();
	}

	public static void pickUpLegoA() throws Exception {
		drawString("pickUpLegoA");
		Motor.C.backward();
		Thread.sleep(PICKUP_MS);
		Motor.C.flt();
	}
	public static void pickUpLegoB() throws Exception {
		drawString("pickUpLegoB");
		Motor.C.forward();
		Thread.sleep(PICKUP_MS);
		Motor.C.stop();
	}


	public static void goVertical() throws Exception {
		drawString("goVertical");
		Motor.A.rotateTo(0);
	}
	public static void hardenVertical() throws Exception {
		drawString("hardenVertical");
		Motor.A.rotateTo(0);
	}

	public static void goHorizontal() throws Exception {
		drawString("goHorizontal");
		Motor.A.rotateTo(-600); // was -620
	}
	public static void releaseLego() throws Exception {
		Motor.B.rotateTo(800);
		moveForwards(Motor.C, 5);
		Motor.C.stop();
		Motor.B.rotateTo(0);
	}


	public static void serverMode() throws Exception {
		LCD.clear();
	    	LCD.drawString("Waiting for Connection...", 0, 0);
		LCD.refresh();
		NXTConnection connection = Bluetooth.waitForConnection();
		LCD.clear();
	    	LCD.drawString("Connected", 0, 0);
		LCD.refresh();
		DataOutputStream dos = connection.openDataOutputStream();
		DataInputStream dis = connection.openDataInputStream();
		boolean connected = true;
		while (connected) {
			drawString("waiting...");
			int r = dis.readInt();
			if (r == 0) {
				drawString("getting brick");
				goHorizontal();
				pickUpLego();
				goVertical();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 1) {
				drawString("placing brick");
				hardenVertical();
				moveBackwards(Motor.C, 22);
				Motor.C.stop();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 2) {
				drawString("disconnected");
				connected = false;
			} else if (r == 3) {
				drawString("pickup lego a");
				goHorizontal();
				pickUpLegoA();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 4) {
				drawString("pickup lego b");
				pickUpLegoB();
				goVertical();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 5) {
				drawString("pressBrick");
				hardenVertical();
				Motor.C.backward();
				Thread.sleep(1100);
				Motor.C.stop();
				Motor.C.forward();
				Thread.sleep(1100);
				Motor.C.stop();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 6) {
				drawString("releasing brick");
				releaseLego();
				Motor.C.rotateTo(0);
				// moveForwards(Motor.C, 22);
				Motor.C.stop();
				dos.writeInt(0);
				dos.flush();
			}
		}
		dis.close();
		dos.close();
		connection.close();
	}

	public static void manualMode() throws Exception {
		int state = 0;
		while (true) {

			if (Button.ENTER.isPressed()) {
				if (state == 0) {
					goHorizontal();
					pickUpLegoA();
					state = 1;
				} else if (state == 1) {
					pickUpLegoB();
					goVertical();
					state = 0;
				}
			} else if (Button.RIGHT.isPressed()) {
				goHorizontal();
				pickUpLego();
				goVertical();
			} else if (Button.LEFT.isPressed()) {
				// goVertical();
				moveBackwards(Motor.C, 20);
				Motor.C.stop();
				releaseLego();
				moveForwards(Motor.C, 20);
				Motor.C.stop();
			} else if (Button.ESCAPE.isPressed()) {
				return;
			}
		}
	}

	public static void main (String[] args) throws Exception {
		Sound.systemSound(true, 2);
		Motor.B.resetTachoCount();
		Motor.A.resetTachoCount();
		Motor.C.resetTachoCount();


		// MANUAL TESTING
		if (false) {
			manualMode();
			return;
		};


		// NXT BLUETOOTH CONTROL
		if (true) {
			serverMode();
			return;
		}

		pickUpLego();
		goVertical();
		moveBackwards(Motor.A, 15);
		Motor.A.stop();
		releaseLego();
		moveForwards(Motor.A, 20);
		goHorizontal();

		if (true) return;

		// drop legos
		for (int i = 0; i < 3; i++) {
		pickUpLego();
		goVertical();
		releaseLego();
		goHorizontal();
		}
		if (true) return;	
		


		if (true) {
			moveBackwards(Motor.C, 28);
			Motor.C.backward();
			Thread.sleep(100);
			Motor.C.stop();
			if (false) {
				for (int i = 0; i < 10; i++) {
					Thread.sleep(100);
					Motor.C.stop();
					Thread.sleep(500);
					Motor.C.backward();
				}
			} else {

			   Thread.sleep(5000);
			}
			moveForwards(Motor.C, 28);
			Motor.C.flt();
		}


		if (false) {
			Motor.B.rotateTo(-700);
			Motor.B.rotateTo(0);
		}

		// go to the top, then to the bottom

		

		// Motor.B.backward();
		// Thread.sleep(2000);
		// Motor.B.flt();
		LCD.clear();
	        LCD.drawInt(Motor.B.getTachoCount(), 0, 0);
		LCD.refresh();		

/*
		LCD.clear();
	        LCD.drawInt(Motor.A.getTachoCount(), 0, 0);
		for (int i = 0; i < 7 && i < vc; i++) {
	        	LCD.drawInt(v[i], 0, i + 1);
	        }
		for (int i = 7; i < vc; i++) {
			LCD.drawInt(v[i], 5, i - 6);
		}
		LCD.refresh();
*/

		// Button.waitForPress();
		if (true) return;


		int tc = Motor.A.getTachoCount();
		Motor.A.backward();
		Thread.sleep(50);
		int ntc = Motor.A.getTachoCount();
		int t = 0;
		int c = 0;
		while (ntc - tc <= -5 && Button.readButtons() == 0) {
			c++;
			t += (ntc - tc);
			Thread.sleep(50);
			LCD.clear();
		        LCD.drawInt(Motor.A.getTachoCount(), 3, 2);
			LCD.drawInt(tc, 3, 3);
			LCD.drawInt(ntc, 3, 4);
			LCD.drawInt(t, 3, 5);
			LCD.drawInt(c, 3, 6);
			LCD.drawInt(ntc - tc, 3, 7);
			LCD.refresh();
			tc = ntc;
			ntc = Motor.A.getTachoCount();
		}
		// Motor.A.backward();
		Motor.A.rotateTo(0);
		// Thread.sleep(200);
		// Motor.A.flt();
		LCD.clear();
                LCD.drawInt(Motor.A.getTachoCount(), 3, 2);
		LCD.drawInt(tc, 3, 3);
		LCD.drawInt(ntc, 3, 4);
		LCD.drawInt(t, 3, 5);
		LCD.drawInt(c, 3, 6);
		LCD.drawInt(ntc - tc, 3, 7);
		LCD.refresh();

		Motor.A.rotateTo(0);
		Button.waitForPress();
		Thread.sleep(10);
	}

	public static void drawString(String str) {
		LCD.clear();
		LCD.drawString(str, 0, 0);
		if (true) {
			LCD.drawInt(Motor.A.getTachoCount(), 0, 1);
			LCD.drawInt(Motor.B.getTachoCount(), 0, 2);
			LCD.drawInt(Motor.C.getTachoCount(), 0, 3);
		}
		LCD.refresh();
	}
}
