import lejos.nxt.*;
import lejos.nxt.addon.*;
import lejos.nxt.comm.*;
import java.io.*;
import javax.bluetooth.*;

/**
 * This program handles Z and plate lock.
 *
 * @author Will Gorman (willgorman@hotmail.com)
 **/
public class MakerLegoBotZ {

	public static void drawString(String str) {
		LCD.clear();
		LCD.drawString(str, 0, 0);
		if (true) {
			LCD.drawInt(Motor.A.getTachoCount(), 0, 1);
			LCD.drawInt(Motor.B.getTachoCount(), 0, 2);
			LCD.drawInt(Motor.C.getTachoCount(), 0, 3);
		}
		LCD.refresh();
	}

	public static void printTachos() {
		LCD.clear();
		        LCD.drawInt(Motor.A.getTachoCount(), 3, 1);
			LCD.drawInt(Motor.B.getTachoCount(), 3, 2);
			LCD.drawInt(Motor.C.getTachoCount(), 3, 3);
			LCD.refresh();
	}

  	public static void resetTachos() {
		Motor.B.resetTachoCount();
		Motor.A.resetTachoCount();
		Motor.C.resetTachoCount();
	}

	static final int Z_INCR = -240;

	// used if the z state starts at the top or middle instead of the bottom of the printer
	static final int INIT_STATE = 0; // 13 * Z_INCR;

	public static void zRotateTo(final int pval, final boolean flt) throws Exception {
		final int val = pval - INIT_STATE;

		Thread t1 = new Thread() {
			public void run() {
				Motor.A.rotateTo(val);
				if (flt) {
					Motor.A.flt();
				} else {
					Motor.A.stop();
				}
			}
		};
		Thread t2 = new Thread() {
			public void run() {
				Motor.B.rotateTo(val);
				if (flt) {
					Motor.B.flt();
				} else {
					Motor.B.stop();
				}
			}
		};
		t1.start();
		t2.start();
		drawString("waiting for threads");
		// wait for motors to stop moving
		while (Motor.A.isMoving() || Motor.B.isMoving()) {
			Thread.sleep(100);
		}
		int atc = Motor.A.getTachoCount() - val;
		int btc = Motor.B.getTachoCount() - val;
		int c = 0;
		while (!(atc > -3 && atc < 3 && btc > -3 && btc < 3) && c < 30) {
			Thread.sleep(100);
			atc = Motor.A.getTachoCount() - val;
			btc = Motor.B.getTachoCount() - val;
			drawString("chk val is:" + val);
			c++;
		}
	}

	public static void backOff() throws Exception {
		Motor.C.rotateTo(280);
		Motor.C.flt();
	}
	public static void lockIn() throws Exception {
		Motor.C.rotateTo(10);
		Motor.C.backward();
		Thread.sleep(650);
		Motor.C.stop();
	}

	public static void serverMode() throws Exception {
		LCD.clear();
	    	LCD.drawString("Waiting for Connection...", 0, 0);
		LCD.refresh();
		NXTConnection connection = Bluetooth.waitForConnection();
		LCD.clear();
	    	LCD.drawString("Connected", 0, 0);
		LCD.refresh();
		DataOutputStream dos = connection.openDataOutputStream();
		DataInputStream dis = connection.openDataInputStream();
		boolean connected = true;
		while (connected) {
			drawString("waiting...");
			int r = dis.readInt();
			if (r == 0) {
				drawString("back off");
				backOff();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 1) {
				drawString("lock in");
				lockIn();
				dos.writeInt(0);
				dos.flush();
			} else if (r == 2) {
				drawString("disconnected");
				connected = false;
			} else {
				drawString("rotate to " + (r - 3));
				zRotateTo((r-3) * Z_INCR, false);
				drawString("done rotating " + (r - 3));
				dos.writeInt(0);
				dos.flush();
				drawString("done rotating " + (r - 3) + " flushed");
			}
		}
		dis.close();
		dos.close();
		connection.close();
	}

	public static void main(String[] args) throws Exception {
		Sound.systemSound(true, 3);
		resetTachos();
		if (true) {
			serverMode();
			return;
		}
		/*
		for (int i = 1; i <= 9; i++) {
			zRotateTo(i * Z_INCR, false);
			drawString("Rotated to " + i);
			Button.ENTER.waitForPressAndRelease();
		}
		drawString("Done Rotating");

		zRotateTo(12 * Z_INCR, false);
		drawString("ENTER backOff");
		Button.ENTER.waitForPressAndRelease();
		*/
		backOff();
		drawString("ENTER lockIn");
		Button.ENTER.waitForPressAndRelease();
		lockIn();
		Button.ENTER.waitForPressAndRelease();
		drawString("Rotations:");
		Button.ENTER.waitForPressAndRelease();
		drawString("ENTER done");
		backOff();
		drawString("ENTER lockIn");
		Button.ENTER.waitForPressAndRelease();
		lockIn();
		Button.ENTER.waitForPressAndRelease();
		drawString("ENTER done");
		// SHUTDOWN

		zRotateTo(0, true);
	}
}
