import lejos.nxt.Button;
import lejos.nxt.LCD;
import lejos.nxt.Motor;

/**
 * This is a useful testing app.
 * 
 * @author Will Gorman (willgorman@hotmail.com)
 **/
public class ManualApp {
	public static void main (String[] args) throws Exception {
		// Manual Run Mode
		Util.resetTachos();
		int state = 0;
		int step = 0;
		while (true) {
			LCD.clear();
			if (state == 0) {
	    			LCD.drawString(" > A " + Motor.A.getTachoCount(), 0, 0);
			} else {
				LCD.drawString("   A "+ Motor.A.getTachoCount(), 0, 0);
			}
			if (state == 1) {
				LCD.drawString(" > B "+ Motor.B.getTachoCount(), 0, 1);
			} else {
				LCD.drawString("   B "+ Motor.B.getTachoCount(), 0, 1);
			}
			if (state == 2) {
				LCD.drawString(" > C "+ Motor.C.getTachoCount(), 0, 2);
			} else {
				LCD.drawString("   C "+ Motor.C.getTachoCount(), 0, 2);

			}
			if (state == 3) {
				LCD.drawString(" > Step "+ step, 0, 3);
			} else {
				LCD.drawString("   Step "+ step, 0, 3);
			}
			if (state == 4) {
				LCD.drawString(" > AnB ", 0, 4);
			} else {
				LCD.drawString("   AnB ", 0, 4);
			}
			if (state == 5) {
				LCD.drawString(" > TachoReset", 0, 5);
			} else {
				LCD.drawString("   TachoReset", 0, 5);
			}
			LCD.refresh();
	
			if (Button.ENTER.isPressed()) {
				state = state + 1;
				if (state == 6) state = 0;
			} else if (Button.LEFT.isPressed()) {
				if (state == 3) {
					step -= 10;
					if (step < 0) {
						step = 100;
					}
				}
				if (state == 5) {
					Motor.B.resetTachoCount();
					Motor.A.resetTachoCount();
					Motor.C.resetTachoCount();
				}
				if (step == 0) {
					if (state == 0) Motor.A.backward();
					if (state == 1) Motor.B.backward();
					if (state == 2) Motor.C.backward();
					if (state == 4) {
						Motor.A.backward();
						Motor.B.backward();
					}

				} else {
					if (state == 0) Motor.A.rotateTo(Motor.A.getTachoCount() - step);
					if (state == 1) Motor.B.rotateTo(Motor.B.getTachoCount() - step);
					if (state == 2) Motor.C.rotateTo(Motor.C.getTachoCount() - step);
					if (state == 4) {
						Motor.A.rotateTo(Motor.A.getTachoCount() - step);
						Motor.B.rotateTo(Motor.A.getTachoCount() - step);
					}
				}
			} else if (Button.RIGHT.isPressed()) {
				if (state == 3) {
					step += 10;
					if (step > 100) {
						step = 0;
					}
				}
				if (state == 5) {
					Motor.B.resetTachoCount();
					Motor.A.resetTachoCount();
					Motor.C.resetTachoCount();
				}
				if (step == 0) {
					if (state == 0) Motor.A.forward();
					if (state == 1) Motor.B.forward();
					if (state == 2) Motor.C.forward();
					if (state == 4) {
						Motor.A.forward();
						Motor.B.forward();
					}
				} else {
					if (state == 0) Motor.A.rotateTo(Motor.A.getTachoCount() + step);
					if (state == 1) Motor.B.rotateTo(Motor.B.getTachoCount() + step);
					if (state == 2) Motor.C.rotateTo(Motor.C.getTachoCount() + step);
					if (state == 4) {
						Motor.A.rotateTo(Motor.A.getTachoCount() + step);
						Motor.B.rotateTo(Motor.A.getTachoCount() + step);
					}
				}
			} else if (Button.ESCAPE.isPressed()) {
				return;
			} else {
				Motor.A.flt();
				Motor.B.flt();
				Motor.C.flt();
			}
			Thread.sleep(100);
		}
		/*
		if (false) {
			while (true) {
				if (Button.RIGHT.isPressed()) {
					// Motor.A.forward();
					Motor.A.rotateTo(Motor.A.getTachoCount() + 115);
				} else if (Button.LEFT.isPressed()) {
					Motor.A.rotateTo(Motor.A.getTachoCount() - 115);
					// Motor.A.backward();
				} else {
					Motor.A.stop();
				}

				if (Button.ENTER.isPressed()) {
					Motor.B.rotateTo(Motor.B.getTachoCount() + 115);
					// Motor.B.forward();
				} else if (Button.ESCAPE.isPressed()) {
					Motor.B.rotateTo(Motor.B.getTachoCount() - 115);
					// Motor.B.backward();
				} else {
					Motor.B.stop();
				}
				Thread.sleep(100);
				printTachos();
			}
		}
		*/
	}


	
}
